function h=disegnastreamline(p,t,vx,vy,nx,ny,nsx,nsy)
% function h=disegnastreamline(P,T,vx,vy,nx,ny,nsx,nsy)
%
% Given the P and T structures for a P2 mesh, the velocity 
% field (vx,vy) associated to the mesh nodes is evaluated on
% a structured rectangular grid made of (nx X ny) blocks and 
% the streamlines associated to the vertices of another 
% structured rectangular grid made of (nx X ny) blocks are 
% plotted. The function returns the handles to the streamlines.
%

% Paolo Massimi and Giovanni Scrofani, Apr 2005

xmax=max(p(1,:));
xmin=min(p(1,:));
ymax=max(p(2,:));
ymin=min(p(2,:));
[X,Y]=meshgrid(linspace(xmin,xmax,nx+1),linspace(ymin,ymax,ny+1));
[SX,SY]=meshgrid(linspace(xmin,xmax,nsx+1),linspace(ymin,ymax,nsy+1));


[bxmin,bymin,bxmax,bymax]=computebbox(p,t);
s=warning('off');
v=valutafieldP2(0,[X(:);Y(:)],p,t,bxmin,bymin,bxmax,bymax,[vx(:);vy(:)]);
warning(s);
n=numel(X);
U=zeros(size(X));
V=zeros(size(X));
U(:)=v(1:n);
V(:)=v(n+1:end);

h=streamline(X,Y,U,V,SX,SY);
h1=streamline(X,Y,-U,-V,SX,SY);
h=[h,h1];

return
